SUMMARY = "RTL8723 kernel driver (wifi + bluetooth)"
DESCRIPTION = "RTL8723 kernel driver"
#LICENSE = "CLOSED"
LICENSE = "GPL-2.0-only"
LIC_FILES_CHKSUM = "file://hal/hal_com_c2h.h;md5=9fdcaba4be35e62d50cf998e9a97635a;endline=19"

PV = "1.0-git"
#SRCREV = "ce4490b1e0dcedec30659dc20b945b90d9c3d83c"
SRCREV = "${AUTOREV}"
SRC_URI = "git://github.com/lwfinger/rtl8723du.git;protocol=https;branch=master \
          "

S = "${WORKDIR}/git"

DEPENDS = "virtual/kernel"

inherit module

EXTRA_OEMAKE  = "ARCH=${ARCH} \
                 KSRC=${STAGING_KERNEL_BUILDDIR} \
                 USER_EXTRA_CFLAGS='-w -DCONFIG_IOCTL_CFG80211 -DRTW_USE_CFG80211_STA_EVENT' \
                "

do_compile () {
    oe_runmake
}

do_install () {
    install -d ${D}${nonarch_base_libdir}/modules/${KERNEL_VERSION}
    install -m 0755 ${B}/8723du.ko ${D}${nonarch_base_libdir}/modules/${KERNEL_VERSION}/8723du.ko

    install -d ${D}${sysconfdir}/modprobe.d
    echo "blacklist rtl8xxxu" > ${D}${sysconfdir}/modprobe.d/rtl8723-blacklist.conf
}

FILES:${PN} += "${sysconfdir}"
RDEPENDS:${PN} += "linux-firmware-rtl8723"
